#include "wav.h"

#include <iostream>

using namespace std;

bool saveFile8Bit( const string& outFile, const u8* data, int size, int sampleFrequency )
{
	wavChunkFormat fmt;
	fmt.wFormatTag = 1;
	fmt.nChannels = 1;
	fmt.wBitsPerSample = 8;
	fmt.nBlockAlign = 1;
	fmt.nSamplesPerSec = sampleFrequency;
	fmt.nAvgBytesPerSec = fmt.nSamplesPerSec * fmt.nChannels * fmt.wBitsPerSample / 8;

	FILE* fout = fopen( outFile.c_str(), "wb" );
	if( !fout ) {
		cerr << "Can't write file " << outFile << "!" << endl;
		return false;
	}

	int writeSize;
	fwrite( "RIFF", 4, 1, fout );
	writeSize = 
		12 + sizeof( fmt ) +	// "WAVEfmt " + length + format-header
		8 + size;				// "data" + length + sampledata

	fwrite( &writeSize, 4, 1, fout );

	fwrite( "WAVEfmt \x10\x00\x00\x00", 12, 1, fout );
	fwrite( (char*)&fmt, sizeof( fmt ), 1, fout );

	fwrite( "data", 4, 1, fout );
	fwrite( &size, 4, 1, fout );

	fwrite( data, size, 1, fout );

	fclose( fout );

	return true;
}
